# Copyright (C) 2013-2023 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 11-May-2023 17:11.

"""waterMark userdefined datapoint type, originally defined in resource file
set apollodev 90:00:01:06:00:00:00:00-4.  """


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined


class waterMark(izot.resources.base.Structure):
    """waterMark userdefined datapoint type.  ."""

    def __init__(self):
        super().__init__(
            key=13,
            scope=4
        )

        self.__timeStamp = izot.resources.base.Array(
            [
                izot.resources.base.Scaled(
                    size=1,
                    signed=False,
                    minimum=0,
                    maximum=255
                ) for i in range(31)
            ]
        )
        self._register(('timeStamp', self.__timeStamp))

        self.__rxPktPS = izot.resources.base.Scaled(
            size=4,
            signed=False,
            scaling=(0.1, 0),
            minimum=0,
            maximum=4.29497E+008
        )
        self._register(('rxPktPS', self.__rxPktPS))

        self.__txPktPS = izot.resources.base.Scaled(
            size=4,
            signed=False,
            scaling=(0.1, 0),
            minimum=0,
            maximum=4.29497E+008
        )
        self._register(('txPktPS', self.__txPktPS))
        self._original_name = 'UNVTwaterMark'
        self._definition = userdefined.add(self)


    def __set_timeStamp(self, v):
        self.__timeStamp._value = v

    timeStamp = property(
        lambda self: self.__timeStamp._value,
        __set_timeStamp,
        None,
        """."""
    )

    def __set_rxPktPS(self, v):
        self.__rxPktPS._value = v

    rxPktPS = property(
        lambda self: self.__rxPktPS._value,
        __set_rxPktPS,
        None,
        """."""
    )

    def __set_txPktPS(self, v):
        self.__txPktPS._value = v

    txPktPS = property(
        lambda self: self.__txPktPS._value,
        __set_txPktPS,
        None,
        """."""
    )

    def __len__(self):
        """Return the length of the type, in bytes."""
        return 39


if __name__ == '__main__':
    # unit test code.
    item = waterMark()
    pass
